/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.resource.conditions.v1;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.class_2960;

public interface ConditionJsonProvider {
    public static void write(JsonObject conditionalObject, ConditionJsonProvider ... conditions) {
        if (conditions == null) {
            return;
        }
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must write at least one condition.");
        if (conditionalObject.has("fabric:load_conditions")) {
            throw new IllegalArgumentException("Object already has a condition entry: " + String.valueOf(conditionalObject));
        }
        JsonArray array = new JsonArray();
        for (ConditionJsonProvider condition : conditions) {
            Objects.requireNonNull(condition, "condition cannot be null");
            array.add((JsonElement)condition.toJson());
        }
        conditionalObject.add("fabric:load_conditions", (JsonElement)array);
    }

    default public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("condition", this.getConditionId().toString());
        this.writeParameters(jsonObject);
        return jsonObject;
    }

    public class_2960 getConditionId();

    public void writeParameters(JsonObject var1);
}

